(ns burningswell.web.coolant
  (:refer-clojure :exclude [get])
  (:require [coolant.core :as coolant]
            [rum.core :as rum]))

(defn coolant?
  "Return true of `x` is a Coolant instance, otherwise false."
  [x]
  (and x (instance? coolant.core.Core @x)))

(defn get
  "Evaluate `getter`."
  [{:keys [coolant] :as system} getter]
  {:pre [(coolant? coolant)]}
  (coolant/evaluate coolant getter))

(defn- coolant
  "Return coolant from `state`."
  [state]
  {:post [(coolant? %)]}
  (-> state :rum/args first :coolant))

(defn- evaluate
  "Evaluate `getter` using coolant from `state`."
  [state getter]
  (coolant/evaluate (coolant state) getter))

(defn mixin
  "Return a Coolant mixin that re-renders when `getter` changes."
  [getter]
  #?(:cljs {:init
            (fn [state props]
              (merge state (evaluate state getter)))
            :will-mount
            (fn [{:keys [rum/react-component] :as state}]
              (->> (fn [getter-state]
                     (when (.isMounted react-component)
                       (let [previous @(rum/state react-component)
                             next (select-keys previous [::observer :rum/args :rum/react-component])
                             next (merge next getter-state)]
                         (set! (.-state react-component) #js {":rum/state" (volatile! next)})
                         (rum/request-render react-component))))
                   (coolant/observe! (coolant state) getter)
                   (assoc state ::observer)))
            :will-unmount
            (fn [state]
              (when-let [unregister (::observer state)]
                (unregister))
              (dissoc state ::observer))}))
