(ns burningswell.web.components.spot-weather
  (:require [burningswell.web.actions :as action]
            [burningswell.web.components.weather :refer [->weather]]
            [hal.core :as hal]
            [om.core :as om]
            [om-tools.core :refer-macros [defcomponent]]))

(defn load-weather
  "Load the weather for `spot`."
  [owner spot]
  (om/set-state! owner :loaded true)
  (action/load-weather (om/get-shared owner) spot))

(defn on-time-change
  "Handle time display change events."
  [owner time]
  (let [spot (om/get-props owner)]
    (when-not (om/get-state owner :loaded)
      (load-weather owner spot))
    (action/display-weather-at-time
     (om/get-shared owner)
     {:spot spot :time time})))

(defn display-time
  "Return the weather display time."
  [spot]
  (or (:weather-time spot)
      (first (sort (keys (hal/embedded spot :weather))))))

(defcomponent spot-weather
  "The spot item weather component."
  [spot owner opts shared]
  (init-state [_]
    {:class (or (:class opts) "spot-weather")})
  (render [_]
    (->weather
     {:time (display-time spot)
      :wave-heights (hal/embedded spot :wave-heights)
      :weather (hal/embedded spot :weather)
      :time-zone (hal/embedded spot :time-zone)}
     {:opts
      {:class (om/get-state owner :class)
       :on-time-change #(on-time-change owner %)
       :on-rating #(action/open-session-dialog (om/get-shared owner) spot)}})))
