(ns burningswell.web.components.like-buttons
  (:require [om-tools.core :refer-macros [defcomponentk]]
            [om.core :as om]
            [sablono.core :refer-macros [html]]))

(defn on-like [data opts]
  (when-not (= (:like data) true)
    (when-let [like (:like opts)]
      (like data))))

(defn on-dislike [data opts]
  (when-not (= (:like data) false)
    (when-let [dislike (:dislike opts)]
      (dislike data))))

(defcomponentk like-button
  [data owner opts]
  (render [_]
    (html
     [:core-tooltip
      {:class
       ["like-buttons__like"
        (if (= (:like data) true)
          "like-buttons__like--current")]
       :label "I like this photo"
       :on-click #(on-like data opts)}
      [:iron-icon {:icon "thumb-up"}]
      [:span.like-buttons__likes
       (:likes data)]])))

(defcomponentk dislike-button
  [data owner opts]
  (render [_]
    (html
     [:core-tooltip
      {:class
       ["like-buttons__dislike"
        (if (= (:like data) false)
          "like-buttons__dislike--current")]
       :label "I dislike this photo"
       :on-click #(on-dislike data opts)}
      [:iron-icon {:icon "thumb-down"}]
      [:span.like-buttons__dislikes
       (:dislikes data)]])))

(defcomponentk like-buttons
  [data owner opts]
  (render [_]
    (html
     [:div.like-buttons
      (->like-button data {:opts opts})
      (->dislike-button data {:opts opts})])))
