(ns burningswell.web.signin-test
  (:require [burningswell.web.test :refer :all]
            [burningswell.web.webdriver :refer [quick-fill]]
            [clj-webdriver.taxi :as taxi]
            [clojure.test :refer :all]))

(defn fill-signin-form
  "Fill the signin form."
  [system {:keys [login password]}]
  (quick-fill
   (:webdriver system)
   {"input[name=login]" login}
   {"input[name=password]" password}))

(defn submit-signin-form
  "Fill and submit the signin form."
  [system credentials]
  (browse-to system "/signin")
  (fill-signin-form system credentials)
  (taxi/submit (:webdriver system) "input[name=login]"))

(defn signin-error
  "Return the error message of the signin form."
  [{:keys [webdriver]} field]
  (some->> {:css (str ".signin-form__" (name field) "__error")}
           (taxi/find-element webdriver)
           (taxi/text webdriver)))

;; (deftest test-signin-sucess
;;   (with-webdriver-system [system env]
;;     (submit-signin-form system {:login "bodhi" :password "secret"})
;;     (wait-for-path (:webdriver system) "/spots")))

;; (deftest test-signin-failure
;;   (with-webdriver-system [system env]
;;     (testing "blank username"
;;       (submit-signin-form system {:login "" :password "secret"})
;;       (is (= (signin-error system :login)
;;              "Login can't be blank.")))
;;     (testing "blank password"
;;       (submit-signin-form system {:login "bodhi" :password ""})
;;       (is (= (signin-error system :password)
;;              "Password can't be blank.")))
;;     (testing "invalid credentials"
;;       (submit-signin-form system {:login "bodhi" :password "invalid"})
;;       (is (= (signin-error system :password)
;;              "Incorrect credentials. Try again!")))))
