(defproject burningswell/web "0.2.6"
  :description "The Burning Swell web application"
  :url "https://github.com/burningswell/web"
  :license {:name "Creative Commons Attribution-NonCommercial 3.0"
            :url "http://creativecommons.org/licenses/by-nc/3.0/"}
  :deploy-repositories [["releases" :clojars]]
  :dependencies [[burningswell/api-client "0.0.49"]
                 [burningswell/geoip "0.1.0"]
                 [burningswell/config "0.1.34"]
                 [burningswell/core "0.0.43"]
                 [burningswell/transit "0.1.1"]
                 [burningswell/pedestal "0.1.0"]
                 [ch.qos.logback/logback-classic "1.1.7"]
                 [ch.qos.logback/logback-core "1.1.7"]
                 [cljs-http "0.1.41"]
                 [cljsjs/google-maps "3.18-1"]
                 [cljsjs/material "1.1.3-1"]
                 [cljsjs/react "15.2.1-1"]
                 [cljsjs/react-dom "15.2.1-1"]
                 [cljsjs/react-dom-server "15.2.1-1"]
                 [com.stuartsierra/component "0.3.1"]
                 [environ "1.1.0"]
                 [hal-clj "0.1.12"]
                 [hiccup "1.0.5"]
                 [hodgepodge "0.1.3"]
                 [io.pedestal/pedestal.jetty "0.5.1-SNAPSHOT"]
                 [io.pedestal/pedestal.service "0.5.1-SNAPSHOT"]
                 [noencore "0.3.3"]
                 [org.clojars.r0man/coolant "0.1.1-SNAPSHOT"]
                 [org.clojure/clojure "1.9.0-alpha7"]
                 [org.clojure/clojurescript "1.9.183"]
                 [org.clojure/core.async "0.2.385"]
                 [org.clojure/tools.logging "0.3.1"]
                 [org.clojure/tools.reader "0.10.0"]
                 [org.omcljs/om "1.0.0-alpha37"]
                 [prismatic/om-tools "0.4.0"]
                 [prismatic/plumbing "0.5.3"]
                 [request-clj "0.3.0"]
                 [rum "0.10.5"]
                 [rum-mdl "0.1.2"]
                 [sablono "0.7.3"]]
  :plugins [[lein-cljsbuild "1.1.3"]
            [lein-environ "1.1.0"]
            [lein-shell "0.5.0"]]
  :aliases {"ci" ["do"
                  ["clean"]
                  ["test-cljs"]
                  ["test-clj"]
                  ["lint"]]
            "test-clj" ["do"
                        ["with-profile" "production" "cljsbuild" "once" "production"]
                        ["difftest"]]
            "test-cljs" ["doo" "phantom" "test" "once"]
            "lint" ["do" ["eastwood"]]}
  :clean-targets ^{:protect false} [:compile-path
                                    :target-path
                                    "resources/public/javascripts"
                                    "resources/public/javascripts/burningswell.js"]
  :cljsbuild {:builds
              [{:id "dev"
                :compiler
                {:asset-path "/javascripts/dev"
                 :main burningswell.web.main
                 :optimizations :none
                 :output-dir "resources/public/javascripts/dev"
                 :output-to "resources/public/javascripts/burningswell.js"
                 :parallel-build true
                 :pretty-print false
                 :source-map true
                 :source-map-timestamp true
                 :verbose false}
                :figwheel
                {:on-jsload "burningswell.web.main/restart"}
                :source-paths ["src/clj" "src/clj-dev"]}
               {:id "devcards"
                :compiler
                {:asset-path "/javascripts/devcards"
                 :main burningswell.web.test.runner
                 :optimizations :none
                 :output-dir "resources/public/javascripts/devcards"
                 :output-to "resources/public/javascripts/burningswell.devcards.js"
                 :parallel-build true
                 :pretty-print false
                 :source-map true
                 :source-map-timestamp true
                 :verbose false}
                :figwheel {:devcards true}
                :source-paths ["src/clj" "src/clj-dev" "test/cljs"]}
               {:id "test"
                :compiler
                {:asset-path "resources/public/javascripts/test"
                 :main burningswell.web.test.runner
                 :optimizations :none
                 :output-dir "resources/public/javascripts/test"
                 :output-to "resources/public/javascripts/burningswell.test.js"
                 :parallel-build true
                 :pretty-print false
                 :source-map true
                 :source-map-timestamp true
                 :verbose false}
                :source-paths ["src/clj" "src/clj-dev" "test/cljs"]}
               {:id "production"
                :compiler
                {:asset-path "/javascripts/production"
                 :externs ["externs/diaporama.js"]
                 :main burningswell.web.main
                 :optimizations :advanced
                 :output-dir "resources/public/javascripts/production"
                 :output-to "resources/public/javascripts/burningswell.js"
                 :parallel-build true
                 :pretty-print false
                 :pseudo-names false
                 :source-map "resources/public/javascripts/burningswell.js.map"
                 :verbose false
                 :modules
                 {:cljs-base
                  {:output-to "resources/public/javascripts/burningswell.js"}
                  :countries
                  {:output-to "resources/public/javascripts/production/burningswell/web/modules/countries.min.js"
                   :entries #{"burningswell.web.modules.countries" "burningswell.web.getter.countries"}}
                  :country
                  {:output-to "resources/public/javascripts/production/burningswell/web/modules/country.min.js"
                   :entries #{"burningswell.web.modules.country" "burningswell.web.getter.country"}}
                  :map
                  {:output-to "resources/public/javascripts/production/burningswell/web/modules/map.min.js"
                   :entries #{"burningswell.web.modules.map" "burningswell.web.getter.map"}}
                  :new-spot
                  {:output-to "resources/public/javascripts/production/burningswell/web/modules/new_spot.min.js"
                   :entries #{"burningswell.web.modules.new-spot" "burningswell.web.getter.new-spot"}}
                  :region
                  {:output-to "resources/public/javascripts/production/burningswell/web/modules/region.min.js"
                   :entries #{"burningswell.web.modules.region" "burningswell.web.getter.region"}}
                  :regions
                  {:output-to "resources/public/javascripts/production/burningswell/web/modules/regions.min.js"
                   :entries #{"burningswell.web.modules.regions" "burningswell.web.getter.regions"}}
                  :search
                  {:output-to "resources/public/javascripts/production/burningswell/web/modules/search.min.js"
                   :entries #{"burningswell.web.modules.search" "burningswell.web.getter.search"}}
                  :signin
                  {:output-to "resources/public/javascripts/production/burningswell/web/modules/signin.min.js"
                   :entries #{"burningswell.web.modules.signin" "burningswell.web.getter.signin"}}
                  :signup
                  {:output-to "resources/public/javascripts/production/burningswell/web/modules/signup.min.js"
                   :entries #{"burningswell.web.modules.signup" "burningswell.web.getter.signup"}}
                  :spot
                  {:output-to "resources/public/javascripts/production/burningswell/web/modules/spot.min.js"
                   :entries #{"burningswell.web.modules.spot" "burningswell.web.getter.spot"}}
                  :spots
                  {:output-to "resources/public/javascripts/production/burningswell/web/modules/spots.min.js"
                   :entries #{"burningswell.web.modules.spots" "burningswell.web.getter.spots"}}}}
                :source-paths ["src/clj" "src/clj-production"]}]
              :test-commands {"phantom" ["bin/test"]}}
  :main ^{:skip-aot true} burningswell.web.main
  :min-lein-version "2.0.0"
  :profiles {:dev {:dependencies [[burningswell/api "0.2.6"]
                                  [com.cemerick/piggieback "0.2.1"]
                                  [clj-webdriver "0.7.2"]
                                  [devcards "0.2.1-7"]
                                  [doo "0.1.7"]
                                  [figwheel-sidecar "0.5.4-7"]
                                  [org.seleniumhq.selenium/selenium-java "2.53.1"]
                                  [org.seleniumhq.selenium/selenium-remote-driver "2.53.1"
                                   :exclusions [com.google.guava/guava]]
                                  [com.codeborne/phantomjsdriver "1.3.0"
                                   :exclusion [org.seleniumhq.selenium/selenium-java
                                               org.seleniumhq.selenium/selenium-server
                                               org.seleniumhq.selenium/selenium-remote-driver]]
                                  [org.clojure/tools.nrepl "0.2.12"]
                                  [reloaded.repl "0.2.2"]
                                  [xml-apis/xml-apis "1.4.01"]]
                   :plugins [[jonase/eastwood "0.2.3"]
                             [lein-difftest "2.0.0"]
                             [lein-figwheel "0.5.4-7"]
                             [lein-doo "0.1.7"]
                             [listora/whitespace-linter "0.1.0"]]
                   :figwheel {:css-dirs ["resources/public/stylesheets"]
                              :http-server-root "public"
                              :server-logfile "logs/figwheel.log"}
                   :repl-options {:nrepl-middleware [cemerick.piggieback/wrap-cljs-repl]
                                  :init-ns user}
                   :source-paths ["dev" "src/clj" "src/clj-dev"]}
             :production {:source-paths ^:replace ["src/clj" "src/clj" "src/clj-production"]}
             :test {:source-paths ^:replace ["src/clj" "src/clj-dev" "test/clj"] ;; TODO: Needed for Figwheel
                    :resource-paths ["test-resources"]}
             :uberjar {:aot :all
                       :main burningswell.web.main
                       :resource-paths ["uberjar-resources"]
                       :source-paths ^:replace ["src/clj" "src/clj-production"]}}
  :source-paths ["src/clj" "test/clj"]
  :test-paths ["test/clj"]
  :uberjar-name "burningswell-web.jar")
