(ns burningswell.web.ui.mixins.event-handler
  #?(:cljs (:import [goog.events EventHandler])))

(defn listen
  "Register an event `handler` for events of `type` on `target`."
  [state target type handler]
  #?(:cljs (.listen (::event-handler state) target (name type) handler)))

(def mixin
  "The event handler mixin."
  {:will-mount
   (fn [state]
     (assoc state ::event-handler #?(:clj nil :cljs (EventHandler.))))
   :will-unmount
   (fn [state]
     (some-> state ::event-handler .removeAll)
     (dissoc state ::event-handler))})

