(ns burningswell.web.system.client
  (:require #?(:clj [request.backend.httpkit])
            #?(:cljs [burningswell.web.system.service-worker :as service-worker])
            #?(:cljs [request.backend.cljs-http])
            [burningswell.api.client :as api]
            [burningswell.web.application :as application]
            [burningswell.web.system.bus :as bus]
            [burningswell.web.system.event-handler :as event-handler]
            [burningswell.web.system.geo-location :as geo-location]
            [burningswell.web.system.history :as history]
            [burningswell.web.local-storage :as local-storage]
            [burningswell.web.system.router :as router]
            [burningswell.web.stores.core :as coolant]
            [com.stuartsierra.component :as component]))

(defn api-client
  "Return a new API client."
  [config]
  (->> #?(:clj :httpkit :cljs :cljs-http)
       (assoc (:api-client config) :async? true :backend)
       (api/new-client)))

(defn client
  "Return a new web client system."
  [config]
  (component/system-map
   :api-client (api-client config)
   :application (application/application)
   :bus (bus/bus)
   :config config
   :coolant (coolant/coolant config)
   :event-handler (event-handler/event-handler)
   :geo-location (geo-location/geo-location)
   :history (history/history {:fragment true})
   :local-storage local-storage/local-storage
   :router (router/router router/routes)
   :service-worker #?(:clj {} :cljs (service-worker/service-worker))))
