(ns burningswell.web.system.bus
  (:require [#?(:clj clojure.core.async :cljs cljs.core.async) :as async]
            [burningswell.web.logging :as log]
            [com.stuartsierra.component :as component]))

(def logger
  "The logger of the current namespace."
  (log/logger "burningswell.web.system.bus"))

(defn publish
  "Subscribe to bus events."
  [bus topic data]
  (->> (assoc data ::topic topic)
       (async/put! (:publisher bus))))

(defn subscribe
  "Subscribe to bus events."
  [bus topic]
  (async/sub (:publication bus) topic (async/chan) true))

(defn start-bus
  "Start the bus."
  [bus]
  (if (:publication bus)
    bus
    (let [publisher (async/chan)
          publication (async/pub publisher #(::topic %))]
      (log/info logger "Bus successfully started.")
      (assoc bus :publisher publisher :publication publication))))

(defn stop-bus
  "Stop the bus."
  [bus]
  (when-let [publisher (:publisher bus)]
    (async/close! publisher))
  (log/info logger "Bus successfully stopped.")
  (assoc bus :publisher nil :publication nil))

(defrecord Bus [publisher publication]
  component/Lifecycle
  (start [bus]
    (start-bus bus))
  (stop [bus]
    (stop-bus bus)))

(defn bus
  "Return a new bus."
  [& [opts]]
  (map->Bus opts))
