(ns burningswell.web.stores.welcome
  (:require [burningswell.web.stores.resources :as resources]
            [coolant.core :as coolant]))

(defn on-reponse [key path-fn]
  (fn [state response]
    (case (:status response)
      200 (assoc state key (map path-fn (:body response)))
      404 state)))

(def store
  "The welcome store."
  (coolant/store
   :welcome
   {:spots []
    :regions []
    :countries []
    :title "Welcome"}
   {:welcome/countries (on-reponse :countries resources/country-path)
    :welcome/regions (on-reponse :regions resources/region-path)
    :welcome/spots (on-reponse :spots resources/spot-path)}))
