(ns burningswell.web.stores.map
  (:require [coolant.core :as coolant]))

(defn update-bounding-box
  "Update the map bounding box of the current route."
  [state bounding-box]
  (assoc state :bounding-box bounding-box))

(defn update-center
  "Update the map center of the current route."
  [state center]
  (assoc state :center center))

(defn update-results
  "Update the map results."
  [state results]
  (assoc state :results results))

(defn update-zoom
  "Update the map zoom level of the current route."
  [state zoom]
  (assoc state :zoom zoom))

(def store
  "The map store."
  (coolant/store
   :map
   {:bounding-box nil
    :center nil
    :results []
    :zoom 4}
   {:map/bounding-box update-bounding-box
    :map/center update-center
    :map/results update-results
    :map/zoom update-zoom}))
