(ns burningswell.web.stores.core
  (:require [burningswell.web.stores.auto-complete :as auto-complete]
            [burningswell.web.stores.page :as page]
            [burningswell.web.stores.resources :as resources]
            [burningswell.web.stores.route :as route]
            [burningswell.web.stores.user :as user]
            [burningswell.web.stores.viewport :as viewport]
            [burningswell.web.util :as util]
            [coolant.core :as coolant]))

(defn setup-state
  "Start the Coolant component."
  [coolant config]
  #?(:cljs (some->>
            (-> config :elements :state)
            (util/read-transit-element)
            (vswap! coolant assoc :state)))
  coolant)

(defn coolant [& [config]]
  (-> (coolant/core
       [auto-complete/store
        page/store
        resources/store
        route/store
        user/store
        viewport/store])
      (setup-state config)))
