(ns burningswell.web.regions-test
  (:require [burningswell.web.test :refer :all]
            [burningswell.db.spots :as spots]
            [clojure.test :refer :all]))

(deftest ^:webdriver test-regions
  (with-webdriver-system [{:keys [webdriver] :as system} env]
    (browse-to system "/regions")
    (is (= (current-layout-link-text webdriver) "Regions"))
    (is (= (current-layout-link-icon webdriver) "account_balance"))))

(deftest ^:webdriver test-regions-near-mundaka
  (with-webdriver-system [{:keys [webdriver] :as system} env]
    (let [spot (spots/mundaka (-> system :api :db))]
      (browse-to system "/regions")
      (set-location-cookie! webdriver (:location spot))
      (browse-to system "/regions")
      (is (= (take 4 (region-headline-names webdriver))
             ["País Vasco" "Lisboa" "Bali" "Hawaii"])))))

(deftest ^:webdriver test-regions-near-uluwatu
  (with-webdriver-system [{:keys [webdriver] :as system} env]
    (let [spot (spots/uluwatu (-> system :api :db))]
      (browse-to system "/regions")
      (set-location-cookie! webdriver (:location spot))
      (browse-to system "/regions")
      (is (= (take 4 (region-headline-names webdriver))
             ["Bali" "País Vasco" "Lisboa" "Hawaii"])))))
