(ns burningswell.web.modules.core
  (:require [burningswell.web.system.core :as system]
            [rum.core :as rum])
  #?(:cljs (:import [goog.module ModuleManager])))

(defn module-loaded
  "Notify the module manager, that `module` has been loaded."
  [module]
  #?(:cljs (let [manager (ModuleManager.getInstance)
                 module (name module)]
             (when (.getModuleInfo manager module)
               (.setLoaded manager module)))))

(defmulti render-client
  "Render the React page for `request` client side."
  (fn [request]
    (-> request :route :name)))

(defmulti render-server
  "Render the HTML page for `request` server side."
  (fn [system]
    (:name (system/current-route system))))
