(ns burningswell.web.modules
  (:require [burningswell.web.modules.deps :as deps]
            [clojure.string :as str]
            [goog.object :as gobject])
  (:import [goog.module ModuleLoader ModuleManager]))

(def module-info
  {"countries" []
   "country" []
   "map" []
   "new-spot" []
   "region" []
   "regions" []
   "root" []
   "search" []
   "settings" []
   "signin" []
   "signout" []
   "signup" []
   "start" []
   "spot" []
   "spots" []
   "welcome" []})

(defonce loader
  (doto (ModuleLoader.)
    (.setDebugMode true)
    ;; Get rid of "Failed to parse SourceMap" errors
    (.setSourceUrlInjection true)))

(defonce manager
  (doto (ModuleManager.getInstance)
    (.setLoader loader)
    (.setAllModuleInfo (clj->js module-info))
    (.setModuleUris (clj->js deps/uris))))

(defn module-main
  "Return the key path for `module`."
  [module]
  (let [module (str/replace (name module) "-" "_")]
    ["burningswell" "web" "modules" module "main"]))

(defn component
  "Resolve the component for `module`."
  [module]
  (apply gobject/getValueByKeys js/window (module-main module)))

(defn component-by-route
  "Resolve the component for `route`."
  [route]
  (component (:name route)))

(defn load-module
  "Load `module` and call `callback` when it has been loaded."
  [module callback]
  (.execOnLoad (ModuleManager.getInstance) (name module) callback))
