(ns burningswell.web.getter.countries
  (:require [burningswell.web.getter.core :refer [layout]]
            [burningswell.web.stores.countries :as countries]
            [burningswell.web.stores.resources :as resources]
            [coolant.core :as coolant]))

(def country-list
  "The getter for the country list."
  (coolant/getter
   [countries/store resources/store]
   (fn [countries resources]
     (resources/resources resources (:list countries)))))

(def page
  "The getter for the countries page."
  (coolant/getter
   [layout countries/store country-list]
   (fn [layout page countries]
     (merge layout page {:countries countries}))))
