(ns burningswell.web.flickr
  (:require [cljs.core.async :as async :refer [chan]]
            [geo.core :as geo]
            [request.core :as http])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defn client [& [opts]]
  (http/new-client
   (merge
    {:scheme :https
     :server-name "api.flickr.com"
     :with-credentials? false}
    opts)))

(defn photo-url
  "Returns the Flickr URL of `photo`."
  [photo & [size]]
  (str "https://farm" (:farm photo) ".staticflickr.com/"
       (:server photo) "/" (:id photo) "_" (:secret photo)
       (if size (str "_" (name size)))
       ".jpg"))

(defn search-photos [client text & [opts]]
  (go (let [{:keys [status body]}
            (<! (http/get
                 client
                 {:scheme :https
                  :server-name "api.flickr.com"
                  :query-params
                  {:api_key (:api-key client)
                   :format "json"
                   :nojsoncallback "1"
                   :method "flickr.photos.search"
                   :license "1,2,3,4,5,6"
                   :tags "surf"
                   :lat (some-> opts :location geo/point-y)
                   :lon (some-> opts :location geo/point-x)
                   :per_page 10}
                  :uri "/services/rest"}))]
        (if (= status 200)
          (with-meta
            (-> body :photos :photo)
            (dissoc (:photos body) :photo))))))
