(ns burningswell.web.stores.user
  (:require [coolant.core :as coolant]))

(defn update-user [state user]
  (merge state user))

(defn update-token [state token]
  (assoc state :auth-token token))

(defn update-settings [state settings]
  (assoc-in state [:_embedded :settings] settings))

(def store
  "The current user store."
  (coolant/store
   :user nil
   {:signin/failed (constantly nil)
    :signin/success update-user
    :signin/token update-token
    :user/logout (constantly nil)
    :user/settings update-settings}))
