(ns burningswell.web.stores.countries
  (:require [burningswell.web.stores.resources :as resources]
            [coolant.core :as coolant]))

(defn load-countries-start [state params]
  (-> (merge state params)
      (assoc :loading? true)))

(defn load-countries-success [state countries]
  (-> (assoc state :loading? false)
      (update :list concat (map resources/country-path countries))))

(defn load-countries-fail [state errors]
  (assoc state :loading? false))

(def store
  "The countries page store."
  (coolant/store
   :countries
   {:list []
    :loading? false
    :title "Countries"
    :page nil}
   {:countries/load-countries-start load-countries-start
    :countries/load-countries-success load-countries-success
    :countries/load-countries-fail load-countries-fail}))
