(ns burningswell.web.ui.diaporama
  (:require #?(:cljs [goog.object :as gobject])
            [rum.core :as rum]))

(def transitions
  [{:id "3da654388c3f3cd031c0",
    :name "burn",
    :owner "gre",
    :glsl "#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D from, to;\nuniform float progress;\nuniform vec2 resolution;\n\nuniform vec3 color;\n\nvoid main() {\n  vec2 p = gl_FragCoord.xy / resolution.xy;\n  gl_FragColor = mix(\n    texture2D(from, p) + vec4(progress*color, 1.0),\n    texture2D(to, p) + vec4((1.0-progress)*color, 1.0),\n    progress);\n}",
    :uniforms {:color [ 0.9, 0.4, 0.2 ]},
    :html_url "https://gist.github.com/3da654388c3f3cd031c0",
    :created_at "2014-05-20T09:06:02Z",
    :updated_at "2015-12-04T07:14:12Z",
    :stars 1.0}
   {:id "b86b90161503a0023231",
    :name "CrossZoom",
    :owner "rectalogic",
    :glsl "// Converted from https://github.com/rectalogic/rendermix-basic-effects/blob/master/assets/com/rendermix/CrossZoom/CrossZoom.frag\n// Which is based on https://github.com/evanw/glfx.js/blob/master/src/filters/blur/zoomblur.js\n// With additional easing functions from https://github.com/rectalogic/rendermix-basic-effects/blob/master/assets/com/rendermix/Easing/Easing.glsllib\n\n#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D from, to;\nuniform float progress;\nuniform vec2 resolution;\n\nuniform float strength;\n\nconst float PI = 3.141592653589793;\n\nfloat Linear_ease(in float begin, in float change, in float duration, in float time) {\n    return change * time / duration + begin;\n}\n\nfloat Exponential_easeInOut(in float begin, in float change, in float duration, in float time) {\n    if (time == 0.0)\n        return begin;\n    else if (time == duration)\n        return begin + change;\n    time = time / (duration / 2.0);\n    if (time < 1.0)\n        return change / 2.0 * pow(2.0, 10.0 * (time - 1.0)) + begin;\n    return change / 2.0 * (-pow(2.0, -10.0 * (time - 1.0)) + 2.0) + begin;\n}\n\nfloat Sinusoidal_easeInOut(in float begin, in float change, in float duration, in float time) {\n    return -change / 2.0 * (cos(PI * time / duration) - 1.0) + begin;\n}\n\n/* random number between 0 and 1 */\nfloat random(in vec3 scale, in float seed) {\n    /* use the fragment position for randomness */\n    return fract(sin(dot(gl_FragCoord.xyz + seed, scale)) * 43758.5453 + seed);\n}\n\nvec3 crossFade(in vec2 uv, in float dissolve) {\n    return mix(texture2D(from, uv).rgb, texture2D(to, uv).rgb, dissolve);\n}\n\nvoid main() {\n    vec2 texCoord = gl_FragCoord.xy / resolution.xy;\n\n    // Linear interpolate center across center half of the image\n    vec2 center = vec2(Linear_ease(0.25, 0.5, 1.0, progress), 0.5);\n    float dissolve = Exponential_easeInOut(0.0, 1.0, 1.0, progress);\n\n    // Mirrored sinusoidal loop. 0->strength then strength->0\n    float strength = Sinusoidal_easeInOut(0.0, strength, 0.5, progress);\n\n    vec3 color = vec3(0.0);\n    float total = 0.0;\n    vec2 toCenter = center - texCoord;\n\n    /* randomize the lookup values to hide the fixed number of samples */\n    float offset = random(vec3(12.9898, 78.233, 151.7182), 0.0);\n\n    for (float t = 0.0; t <= 40.0; t++) {\n        float percent = (t + offset) / 40.0;\n        float weight = 4.0 * (percent - percent * percent);\n        color += crossFade(texCoord + toCenter * percent * strength, dissolve) * weight;\n        total += weight;\n    }\n    gl_FragColor = vec4(color / total, 1.0);\n}",
    :uniforms {:strength 0.4},
    :html_url "https://gist.github.com/b86b90161503a0023231",
    :created_at "2014-05-25T01:24:39Z",
    :updated_at "2016-02-02T03:25:07Z",
    :stars 5.0}])

(def diaporama-mixin
  "The diaporama mixin."
  {:did-mount
   (fn [state]
     (->> #?(:cljs (js/Diaporama.
                    (rum/ref-node state "diaporama")
                    nil (clj->js (-> state :rum/args first))))
          (assoc state :diaporama)))
   :did-remount
   (fn [old-state new-state]
     #?(:cljs (when-not (= (-> old-state :rum/args first)
                           (-> new-state :rum/args first))
                (doseq [[k v] (-> new-state :rum/args first)]
                  (gobject/set (:diaporama new-state) (name k) (clj->js v)))))
     new-state)
   :will-unmount
   (fn [state]
     #?(:cljs (some-> state :diaporama (.destroy)))
     state)})

(rum/defc diaporama < rum/static diaporama-mixin
  "Render an image."
  [opts]
  [:div
   ;; TODO: Why is str needed here? Sablono bug?
   {:class (str (:class opts))
    :key (:key opts)
    :ref "diaporama"
    :style {:min-height "100%"}}])
