(ns burningswell.web.modules.search
  #?(:cljs (:require-macros [cljs.core.async.macros :refer [go]]))
  (:require [burningswell.web.api :as api]
            [burningswell.web.coolant :as coolant]
            [burningswell.web.getter.search :as search]
            [burningswell.web.modules.core :refer [module-loaded render-server]]
            [burningswell.web.stores.search :as store]
            [burningswell.web.system.core :as system]
            [burningswell.web.ui.layout :refer [layout]]
            [burningswell.web.ui.search-list :refer [search-list]]
            [clojure.core.async :refer [<! #?(:clj go)]]
            [clojure.string :as str]
            [rum.core :as rum]))

(defn search
  "Search countries, regions and spots."
  [system & [{:keys [query] :as params}]]
  (system/dispatch! system :search/query query)
  (go (when-not (str/blank? query )
        (let [{:keys [status body]} (<! (api/search-details system params))]
          (case status
            200 (system/dispatch! system :search/results body)
            nil ;; Request canceled
            )))))

(rum/defc content < rum/static
  "Render the content of the search page."
  [system {:keys [results] :as page}]
  (layout
   system page
   [:div.search__content
    (search-list system results)]))

(rum/defcs page < (coolant/mixin search/page)
  "Render the search page."
  [page system]
  (content system page))

(defmethod system/change-route :search [system route]
  (coolant/register-stores! system [store/store])
  (system/route-changed system route)
  (search system (:query-params route)))

(defmethod render-server :search [system]
  #?(:clj (->> (coolant/get system search/page)
               (content system)
               (rum/render-html))))

(def ^:export main page)
(module-loaded :search)
