(ns burningswell.web.logging
  #?(:clj (:require [io.pedestal.log :as log]))
  #?(:cljs (:require [goog.log :as log])))

(defn logger
  "Return the logger for `name`."
  [name]
  #?(:cljs (when ^boolean goog.DEBUG (log/getLogger name))))

(defn debug
  "Log `message` at debug level using `logger`."
  [logger message]
  #?(:clj (log/debug :msg message)
     :cljs (when ^boolean goog.DEBUG (log/fine logger message))))

(defn error
  "Log `message` at error level using `logger`."
  [logger message]
  #?(:clj (log/error :msg message)
     :cljs (when ^boolean goog.DEBUG (log/error logger message))))

(defn info
  "Log `message` at info level using `logger`."
  [logger message]
  #?(:clj (log/info :msg message)
     :cljs (when ^boolean goog.DEBUG (log/info logger message))))

(defn warning
  "Log `message` at warning level using `logger`."
  [logger message]
  #?(:clj (log/warn :msg message)
     :cljs (when ^boolean goog.DEBUG (log/warning logger message))))
