(ns burningswell.web.ui.country-list
  (:require [burningswell.web.ui.infinite-list :refer [infinite-list]]
            [burningswell.web.ui.country-card :refer [country-card]]
            [rum.core :as rum]))

(defn country-list-item-key
  "Return the React key for a country list item."
  [system country]
  (str "country-list-item-" (:id country)))

(rum/defc country-list-item < rum/static {:key-fn country-list-item-key}
  "Render a country list item."
  [system country]
  [:div.country-list__item
   (country-card system country)])

(rum/defc country-list < rum/static
  "Render a country list."
  [system countrys]
  [:div.country-list
   (for [country countrys]
     (country-list-item system country))])

(rum/defc infinite-country-list < rum/static
  "Render a country list."
  [system countrys & [opts]]
  (infinite-list
   (map #(country-card system %1) countrys)
   (merge {:list-class "country-list"
           :item-class "country-list__item"} opts)))
