(ns burningswell.web.stores.regions
  (:require [burningswell.web.stores.resources :as resources]
            [coolant.core :as coolant]))

(defn load-regions-start [state params]
  (-> (merge state params)
      (assoc :loading? true)))

(defn load-regions-success [state regions]
  (-> (assoc state :loading? false)
      (update :list concat (map resources/region-path regions))))

(defn load-regions-fail [state errors]
  (assoc state :loading? false))

(def store
  "The regions page store."
  (coolant/store
   :regions
   {:list []
    :loading? false
    :title "Regions"
    :page nil}
   {:regions/load-regions-start load-regions-start
    :regions/load-regions-success load-regions-success
    :regions/load-regions-fail load-regions-fail}))


