(ns burningswell.web.ui.region-list
  (:require [burningswell.web.ui.infinite-list :refer [infinite-list]]
            [burningswell.web.ui.region-card :refer [region-card]]
            [rum.core :as rum]))

(defn region-list-item-key
  "Return the React key for a region list item."
  [system region]
  (str "region-list-item-" (:id region)))

(rum/defc region-list-item < rum/static {:key-fn region-list-item-key}
  "Render a region list item."
  [system region]
  [:div.region-list__item
   (region-card system region)])

(rum/defc region-list < rum/static
  "Render a region list."
  [system regions]
  [:div.region-list
   (for [region regions]
     (region-list-item system region))])

(rum/defc infinite-region-list < rum/static
  "Render a region list."
  [system regions & [opts]]
  (infinite-list
   (map #(region-card system %1) regions)
   (merge {:class "region-list"
           :content-class "region-list__content"
           :item-class "region-list__item"} opts)))
