(ns burningswell.web.ui.facebook
  (:require [no.en.core :refer [format-url]]
            [rum.core :as rum]
            [rum.mdl :as mdl]))

(defn login-url
  "Return the Facebook dialog url."
  [config]
  (format-url
   {:scheme :https
    :server-name "www.facebook.com"
    :uri "/v2.3/dialog/oauth"
    :query-params
    {:client_id (:client-id config)
     :redirect_uri (:redirect-uri config)
     :scope "email"}}))

(defn redirect-to-login
  "Redirect the user to the Facebook login dialog."
  [config]
  #?(:cljs (set! (.-location js/window) (login-url config))))

(defn on-login-click
  "Handle clicks on the login button."
  [config event]
  #?(:cljs (do (redirect-to-login config)
               (.preventDefault event))))

(rum/defc login-button < rum/static
  "Render a Facebook login button."
  [config text & [opts]]
  (mdl/button
   {:class (:class opts)
    :mdl [:colored :raised :ripple]
    :on-click #(on-login-click config %)}
   text))
