(ns burningswell.web.getter.core
  (:require [burningswell.web.stores.auto-complete :as auto-complete]
            [burningswell.web.stores.page :as page]
            [burningswell.web.stores.route :as route]
            [burningswell.web.stores.user :as user]
            [coolant.core :as coolant]))

(def route
  (coolant/getter [route/store] identity))

(def auto-complete
  (coolant/getter [auto-complete/store] identity))

(def auth-token
  (coolant/getter [user/store] (fn [user] (:auth-token user))))

(def current-location
  (coolant/getter [page/store] (fn [page] (:current-location page))))

(def current-user
  (coolant/getter [user/store] identity))

(def layout
  "The getter for a all pages."
  (coolant/getter
   [auto-complete/store page/store route/store user/store]
   (fn [auto-complete page route user]
     (->> {:auto-complete auto-complete
           :route route
           :user user}
          (merge page)))))
