(ns burningswell.web.ui.region-headline
  (:require [burningswell.web.ui.links :as link-to]
            [burningswell.web.util :as util]
            [rum.core :as rum]))

(rum/defc region-headline < rum/static
  "Render the region headline."
  [system region]
  (let [country (-> region :_embedded :country)]
    [:div.region-headline
     [:h6.region-headline__name
      [:img.region-headline__geometry
       {:src (util/region-geo-image-url system region)}]
      (link-to/region system region)]
     [:div.region-headline__summary
      [:span.region-headline__country
       [:img.region-headline__flag
        {:src (util/country-flag-url country) }]
       (link-to/country system country)]
      ", "
      [:span.region-headline__spot-count
       (:spot-count region)
       (util/pluralize
        (:spot-count region)
        " spot"
        " spots")]]]))
