(ns burningswell.web.ui.region-card
  (:require [burningswell.web.ui.image :refer [image]]
            [burningswell.web.ui.region-headline :refer [region-headline]]
            [rum.core :as rum]))

(rum/defc region-image < rum/static
  "Render a region image."
  [region]
  (when-let [src (-> region :_embedded :photo :images :small :url)]
    (image
     {:class "region-card__image"
      :preload true
      :sizing "cover"
      :fade true
      :src src})))

(defn region-card-key
  "Return the region list item key."
  [system region]
  (str "region-list-item-" (:id region)))

(rum/defc region-card < rum/static {:key-fn region-card-key}
  "Render the region list item."
  [system region]
  [:div.region-card
   (region-image region)
   (region-headline system region)])

(rum/defc region-cards < rum/static
  "Render a region list."
  [system regions]
  [:div.region-cards
   (for [region regions]
     (region-card system region))])
