(ns burningswell.web.spot-test
  (:require [burningswell.web.test :refer :all]
            [burningswell.web.signin-test :as signin]
            [burningswell.web.taxi :as taxi]
            [clojure.test :refer :all]))

(defn photo-likes
  "Return the number of likes for a photo."
  [webdriver]
  (-> (taxi/text webdriver ".like-buttons__likes")
      (Long/parseLong)))

(defn photo-dislikes
  "Return the number of dislikes for a photo."
  [webdriver]
  (-> (taxi/text webdriver ".like-buttons__dislikes")
      (Long/parseLong)))

(defn wait-for-photo-likes
  "Wait for the number of likes of a photo."
  [webdriver likes]
  (taxi/wait-until
   webdriver
   (fn [_] (= likes (photo-likes webdriver)))
   10000 200))

(defn wait-for-photo-dislikes
  "Wait for the number of dislikes of a photo."
  [webdriver dislikes]
  (taxi/wait-until
   webdriver
   (fn [_] (= dislikes (photo-dislikes webdriver)))
   10000 200))

(defn like-photo
  "Like a photo."
  [webdriver]
  (taxi/click webdriver ".like-buttons__like") )

(defn dislike-photo
  "Dislike a photo."
  [webdriver]
  (taxi/click webdriver ".like-buttons__dislike") )

#_(deftest ^:webdriver test-spot-photo-likes
    (with-webdriver-system [{:keys [webdriver] :as system} env]
      (browse-to system "/signin")
      (signin/submit-signin-form system (:bodhi credentials))
      (wait-for-path webdriver "/spots")
      (browse-to system "/spots/1")
      (let [likes (photo-likes webdriver)]
        (like-photo webdriver)
        (wait-for-photo-likes webdriver (inc likes)))
      (let [dislikes (photo-dislikes webdriver)]
        (dislike-photo webdriver)
        (wait-for-photo-dislikes webdriver (inc dislikes)))))
