(ns burningswell.web.modules.country
  #?(:cljs (:require-macros [cljs.core.async.macros :refer [go]]))
  (:require [burningswell.web.api :as api]
            [burningswell.web.coolant :as coolant]
            [burningswell.web.getter.country :as country]
            [burningswell.web.modules.core :refer [module-loaded render-server]]
            [burningswell.web.system.core :as system]
            [burningswell.web.ui.layout :refer [layout]]
            [burningswell.web.ui.region-list :refer [region-list]]
            [clojure.core.async :refer [<! #?(:clj go)]]
            [rum.core :as rum]))

(defn country-regions
  "Fetch the regions in `country`."
  [system country & [params]]
  (go (let [params (merge {:min-spots 1} params)
            regions (:body (<! (api/regions-in-country system country params)))]
        (system/dispatch! system :country/regions regions))))

(defn country
  "Fetch the country."
  [system country]
  (system/dispatch! system :page/loading true)
  (system/dispatch! system :country/country country)
  (go (let [country (:body (<! (api/country system country)))]
        (system/dispatch! system :country/country country)
        (country-regions system country)
        (system/dispatch! system :page/loading false))))

(rum/defc content < rum/static
  "Render the content of the country page."
  [system {:keys [country regions] :as page}]
  (layout
   system page
   [:div.country__content
    (region-list system regions)]))

(rum/defcs page < (coolant/mixin country/page)
  "Render the country page."
  [page system]
  (content system page))

(defmethod system/change-route :country [system route]
  (system/route-changed system route)
  (country system (:params route)))

(defmethod render-server :country [system]
  #?(:clj (->> (coolant/get system country/page)
               (content system)
               (rum/render-html))))

(def ^:export main page)
(module-loaded :country)

