(ns burningswell.web.mixins.google-map
  (:require [burningswell.web.core :as core]
            [geo.core :as geo]
            [om-tools.core :refer-macros [defcomponentk]]
            [om-tools.mixin :refer-macros [defmixin]]
            [om.core :as om]))

(def berlin (geo/point 4326 13.4093 52.5222))

(defn center
  "Return the map center of `owner`."
  [owner]
  (or (om/get-state owner :center) berlin))

(defn zoom
  "Return the zoom level of `owner`."
  [owner]
  (or (om/get-state owner :zoom) 11))

(defn map-opts
  "Return the map options of `owner`."
  [owner]
  (let [center (center owner)]
    {:center
     {:lat (geo/point-y center)
      :lng (geo/point-x center)}
     :zoom (zoom owner)}))

(defn map-ref
  "Return the map reference of `owner`."
  [owner]
  (or (om/get-state owner :ref) "map"))

(defn map-node
  "Return the map node of `owner`."
  [owner]
  (->> (map-ref owner)
       (om/get-node owner)))

(defn init-map
  "Initialize the google map."
  [owner]
  (if-let [node (map-node owner)]
    (let [opts (clj->js (map-opts owner))
          map (google.maps.Map. node opts)]
      (set! (. owner -map) map))
    (println "Can't find google map node:" (map-ref owner))))

(defmixin google-map-mixin
  "The google map mixin."
  (did-mount [owner]
    (init-map owner))
  (will-unmount [owner]
    (google.maps.event.clearInstanceListeners (. owner -map))
    (set! (. owner -map) nil)))
