(ns burningswell.web.interceptors
  (:require [burningswell.pedestal.interceptors :as interceptors]
            [burningswell.geoip.interceptor :as geoip]
            [io.pedestal.http :as http]
            [io.pedestal.interceptor :refer [interceptor]]
            [ring.middleware.cookies :as cookies]))

(def cookies
  "Interceptor that adds cookies to the request."
  (interceptor
   {:name ::cookies
    :enter #(update % :request cookies/cookies-request)}))

(def route
  "Interceptor that adds the current route to the request."
  (interceptor
   {:name ::route
    :enter
    (fn [context]
      (->> {:name (-> context :route :route-name)
            :params (-> context :route :path-params)
            :query-params (-> context :request :query-params)}
           (assoc-in context [:request :route])))}))

(def geoip
  "The GeoIP interceptor."
  (geoip/geoip))

(defn init
  "Initialize the interceptors for `server`."
  [server]
  (->> (fn [interceptors]
         (vec (concat
               [(interceptors/dependencies server)
                interceptors/proxy-headers]
               interceptors)))
       (update server ::http/interceptors)))
