(ns burningswell.web.getter.regions
  (:require [burningswell.web.getter.core :refer [layout]]
            [burningswell.web.stores.regions :as regions]
            [burningswell.web.stores.resources :as resources]
            [coolant.core :as coolant]))

(def region-list
  "The getter for the region list."
  (coolant/getter
   [regions/store resources/store]
   (fn [page resources]
     (resources/resources resources (:list page)))))

(def page
  "The getter for the regions page."
  (coolant/getter
   [layout regions/store region-list]
   (fn [layout regions-page region-list]
     (->> {:regions region-list
           :title (:title regions-page)}
          (merge layout)))))
