(ns burningswell.web.getter.region
  (:require [burningswell.web.getter.core :refer [layout]]
            [burningswell.web.stores.region :as region]
            [burningswell.web.stores.resources :as resources]
            [coolant.core :as coolant]))

(def region
  "The getter for the region."
  (coolant/getter
   [region/store resources/store]
   (fn [page resources]
     (resources/resource resources (:region page)))))

(def spots
  "The getter for the spots."
  (coolant/getter
   [region/store region resources/store]
   (fn [page region resources]
     (->> (get-in page (region/spots-path region))
          (resources/resources resources)))))

(def page
  "The getter for the region page."
  (coolant/getter
   [layout region spots]
   (fn [layout region spots]
     (->> {:region region
           :spots spots
           :title (:name region)}
          (merge layout)))))
