(ns burningswell.web.main
  (:require [burningswell.web.logging :as log]
            [burningswell.web.system.client :as system]
            [burningswell.web.util :as util]
            [com.stuartsierra.component :as component])
  (:import goog.debug.Console))

(def logger
  "The logger of the current namespace."
  (log/logger "burningswell.web.main"))

(defonce *system* nil)

(defn configure-logging
  "Configure logging."
  []
  (when ^boolean goog.DEBUG
    (.setCapturing (Console.) true)))

(defn start-system
  "Start the system with `config` and bind it to `*system*`."
  [& [config]]
  (->> config system/client component/start (set! *system*))
  (log/info logger "System started.")
  *system*)

(defn stop-system
  "Stop the system bound to `*system*`."
  []
  (some->> *system* component/stop (set! *system*))
  (log/info logger "System stopped.")
  *system*)

(defn ^:export start
  "Start the web application."
  [config]
  (enable-console-print!)
  (configure-logging)
  (-> config util/read-transit-element start-system)
  (log/info logger "Web application started.")
  *system*)

(defn ^:export restart
  "Restart the web application."
  []
  (let [config (:config *system*)]
    (stop-system)
    (start-system config)
    (log/info logger "Web application restarted.")
    *system*))
