(ns burningswell.web.modules.region
  (:require [burningswell.web.coolant :as coolant]
            [burningswell.web.getter.region :as region]
            [burningswell.web.modules.core :refer [module-loaded render-server]]
            [burningswell.web.ui.layout :refer [layout]]
            [burningswell.web.ui.spot-list :refer [spot-list]]
            [rum.core :as rum]))

(rum/defc content < rum/static
  "Render the content of the region page."
  [system {:keys [region spots] :as page}]
  (layout
   system page
   [:div.region__content
    (spot-list system spots)]))

(rum/defcs page < (coolant/mixin region/page)
  "Render the region page."
  [page system]
  (content system page))

(defmethod render-server :region [system]
  #?(:clj (->> (coolant/get system region/page)
               (content system)
               (rum/render-html))))

(def ^:export main page)
(module-loaded :region)
