(ns burningswell.web.modules.signout
  "The signout page."
  (:require [burningswell.web.coolant :as coolant]
            [burningswell.web.getter.signout :as signout]
            [burningswell.web.modules.core :refer [module-loaded render-server]]
            [burningswell.web.ui.image :refer [image]]
            [burningswell.web.ui.layout :refer [layout]]
            [rum.core :as rum]))

(defn signout-background
  "Render the background image of the signout page."
  []
  (image
   {:class "signout__image"
    :background "black"
    :preload true
    :sizing "cover"
    :fade true
    :src "https://farm9.staticflickr.com/8113/8683411065_e546bcdd3b_o.jpg"}))

(rum/defc content < rum/static
  "Render the content of the signout page."
  [system page]
  (layout
   system page
   [:div.signout__content
    (signout-background)]))

(rum/defcs page < (coolant/mixin signout/page)
  "Render the signout page."
  [page system]
  (content system page))

(defmethod render-server :signout [system]
  #?(:clj (->> (coolant/get system signout/page)
               (content system)
               (rum/render-html))))

(def ^:export main page)
(module-loaded :signout)
