(ns burningswell.web.ui.spot-list
  (:require [burningswell.web.ui.spot-card :refer [spot-card]]
            [rum.core :as rum]))

(defn spot-list-item-key
  "Return the React key for a spot list item."
  [system spot]
  (str "spot-list-item-" (:id spot)))

(rum/defc spot-list-item < rum/static {:key-fn spot-list-item-key}
  "Render a spot list item."
  [system spot]
  [:div.spot-list__item
   (spot-card system spot)])

(rum/defc spot-list < rum/static
  "Render a spot list."
  [system spots]
  [:div.spot-list
   (for [spot spots]
     (spot-list-item system spot))])
