(ns burningswell.web.stores.user
  (:require [coolant.core :as coolant]))

(defn update-user [state user]
  (merge state user))

(defn update-token [state token]
  (assoc state :auth-token token))

(def store
  "The current user store."
  (coolant/store
   :user nil
   {:signin/failed (constantly nil)
    :signin/success update-user
    :signin/token update-token
    :user/logout (constantly nil)}))
