(ns burningswell.web.mixins.coolant
  (:require [coolant.core :as coolant]
            [om-tools.mixin :refer-macros [defmixin]]
            [om.core :as om]))

(defmixin coolant-mixin
  (will-unmount [owner]
    (when-let [unobserve (.-coolant-mixin-unobserve owner)]
      (unobserve)
      (set! (.-coolant-mixin-unobserve owner) nil)))
  (observe [owner getter & [observe-fn]]
    (let [observe-fn (or observe-fn #(om/set-state! owner %))
          coolant (om/get-shared owner :store)]
      (assert coolant "Can't find :store in shared.")
      (set! (.-coolant-mixin-unobserve owner)
            (coolant/observe! coolant getter observe-fn))
      (observe-fn (coolant/evaluate coolant getter)))))
