(ns burningswell.web.getter.spots
  (:require [burningswell.web.getter.core :refer [layout]]
            [burningswell.web.stores.resources :as resources]
            [burningswell.web.stores.spots :as spots]
            [coolant.core :as coolant]))

(def spot-list
  "The getter for the spot list."
  (coolant/getter
   [spots/store resources/store]
   (fn [page resources]
     (resources/resources resources (:list page)))))

(def page
  "The getter for the spots page."
  (coolant/getter
   [layout spots/store spot-list]
   (fn [layout spots-page spot-list]
     (->> {:spots spot-list
           :title "Spots"}
          (merge layout)))))
