(ns burningswell.web.components.crosshair-map
  (:require [burningswell.web.mixins.google-map :refer [google-map-mixin]]
            [burningswell.web.mixins.spot-map :refer [spot-map-mixin]]
            [goog.dom :as dom]
            [goog.style :as style]
            [om-tools.core :refer-macros [defcomponentk]]
            [sablono.core :as html :refer-macros [html]]))

(defn crosshair
  "Return the crosshair control element."
  []
  (let [image (dom/createElement "img")]
    (set! (.-index image) 0)
    (set! (.-src image) "/images/crosshair.png")
    image))

(defn add-control
  "Add the `control` to the map of `owner`."
  [owner control]
  (when-let [map (.-map owner)]
    (let [position google.maps.ControlPosition.CENTER]
      (.push (get (.-controls map) position) control))))

(defcomponentk crosshair-map
  "Return a map component with a crosshair control."
  [data owner opts]
  (:mixins google-map-mixin spot-map-mixin)
  (init-state [_]
    {:center (:center opts)
     :channel (:channel opts)
     :on-idle (:on-idle opts)
     :ref "crosshair-map"
     :zoom (:zoom opts)})
  (did-mount [_]
    (add-control owner (crosshair)))
  (render [_]
    (html
     [:div
      {:class (:class opts)
       :ref "crosshair-map"}])))
