(ns burningswell.web.build
  (:require [cljs.build.api :as build]))

(defmulti build
  "Build the ClojureScript sources."
  (fn [type] (keyword type)))

(defmethod build :production [type]
  (build/build
   (build/inputs "src/cljs" "src/cljs-production")
   {:asset-path "/javascripts/production"
    :externs ["externs/google_maps_api_v3.js"]
    :main 'burningswell.web.main
    :optimizations :advanced
    :output-dir "resources/public/javascripts/production"
    :pretty-print false
    :pseudo-names false
    :source-map true
    :verbose true
    :modules
    {:cljs-base
     {:output-to "resources/public/javascripts/burningswell.js"}
     :countries
     {:output-to "resources/public/javascripts/production/burningswell/web/modules/countries.js"
      :entries '#{burningswell.web.modules.countries}}
     :country
     {:output-to "resources/public/javascripts/production/burningswell/web/modules/country.js"
      :entries '#{burningswell.web.modules.country}}
     :new-spot
     {:output-to "resources/public/javascripts/production/burningswell/web/modules/new_spot.js"
      :entries '#{burningswell.web.modules.new-spot}}
     :region
     {:output-to "resources/public/javascripts/production/burningswell/web/modules/region.js"
      :entries '#{burningswell.web.modules.region}}
     :regions
     {:output-to "resources/public/javascripts/production/burningswell/web/modules/regions.js"
      :entries '#{burningswell.web.modules.regions}}
     :search
     {:output-to "resources/public/javascripts/production/burningswell/web/modules/search.js"
      :entries '#{burningswell.web.modules.search}}
     :signin
     {:output-to "resources/public/javascripts/production/burningswell/web/modules/signin.js"
      :entries '#{burningswell.web.modules.signin}}
     :signup
     {:output-to "resources/public/javascripts/production/burningswell/web/modules/signup.js"
      :entries '#{burningswell.web.modules.signup}}
     :spot
     {:output-to "resources/public/javascripts/production/burningswell/web/modules/spot.js"
      :entries '#{burningswell.web.modules.spot}}
     :spots
     {:output-to "resources/public/javascripts/production/burningswell/web/modules/spots.js"
      :entries '#{burningswell.web.modules.spots}}}}))

(defmethod build :default [type]
  (build/build
   (build/inputs "src/cljs" "src/cljs-dev")
   {:asset-path "/javascripts/dev"
    :main 'burningswell.web.main
    :optimizations :none
    :output-dir "resources/public/javascripts/dev"
    :output-to "resources/public/javascripts/burningswell.js"
    :pretty-print true
    :source-map true
    :source-map-timestamp true
    :verbose true}))

(defn -main [& args]
  (build (first args)))
