(ns burningswell.web.stores.countries
  (:require [burningswell.web.stores.resources :as resources]
            [coolant.core :as coolant]))

(defn update-country-list [state countries]
  (assoc state :list (map resources/country-path countries)))

(def store
  "The countries page store."
  (coolant/store
   :countries
   {:list []
    :title "Countries"}
   {:countries/list update-country-list}))
