(ns burningswell.web.components.spot-map
  (:require [burningswell.web.mixins.google-map :refer [google-map-mixin]]
            [burningswell.web.mixins.spot-map :refer [spot-map-mixin]]
            [om-tools.core :refer-macros [defcomponentk]]
            [sablono.core :as html :refer-macros [html]]))

(defcomponentk spot-map
  "Return a spot map component."
  [[:data spot spots] owner opts]
  (:mixins google-map-mixin spot-map-mixin)
  (init-state [_]
    {:center (:center opts)
     :channel (:channel opts)
     :on-idle (:on-idle opts)
     :ref "spot-map"
     :zoom (:zoom opts)})
  (render [_]
    (html
     [:div
      {:class (:class opts)
       :ref "spot-map"}])))
