(ns burningswell.web.ui.links
  (:require [burningswell.web.history :as history]
            [clojure.string :as str]
            [rum.core :as rum]))

(defn on-click-handler
  "Return an on-click handler for `path`."
  [system path]
  #?(:cljs (fn [event]
             (history/set-token! (:history system) path)
             (.preventDefault event))))

(defn history-key
  "Return the React key for a history link."
  [system path content & [opts]]
  (str "link-to-history-" (hash [path content])))

(rum/defc history < rum/static {:key-fn history-key}
  "Render a HTML5 history link."
  [system path content & [opts]]
  ;; TODO: Find a better way.
  `[:a ~(->> (on-click-handler system path)
             (assoc opts :href path :on-click))
    ~@content])

(defn countries
  "Render a HTML5 history link to the countries page."
  [system & [opts]]
  (history system "/countries" "Countries" opts))

(defn country
  "Render a HTML5 history link to a country."
  [system country]
  (when (:id country)
    (history
     system
     (str "/countries/" (:id country))
     (:name country)
     {:class #{"link" "link--country"}})))

(defn create-account
  "Render a HTML5 history link to the signup page."
  [system & [opts]]
  (history system "/signup" "Create one" opts))

(defn login
  "Render a HTML5 history link to the signin page."
  [system & [opts]]
  (history system "/signin" "Login" opts))

(defn region
  "Render a HTML5 history link to a region."
  [system region]
  (when (:id region)
    (history
     system
     (str "/regions/" (:id region))
     (:name region)
     {:class #{"link" "link--region"}})))

(defn spot
  "Render a HTML5 history link to a spot."
  [system spot]
  (when (:id spot)
    (history
     system
     (str "/spots/" (:id spot))
     (:name spot)
     {:class #{"link" "link--spot"}})))
