(ns burningswell.web.modules.root
  (:require #?(:cljs [burningswell.web.modules :as modules])
            [burningswell.web.coolant :as coolant]
            [burningswell.web.getter.root :as root]
            [burningswell.web.ui.layout :refer [layout]]
            [rum.core :as rum]
            [rum.mdl :as mdl]))

(defn current-page
  "Return the current route from `state`."
  [page]
  #?(:cljs (modules/component-by-route (-> page :route :current))))

(rum/defc content < rum/static
  "Render the content of the root page."
  [system state]
  [:div.root__content
   #?(:cljs (mdl/spinner
             {:class "root__loading"
              :is-active true}))])

(rum/defcs page < (coolant/mixin root/page)
  "Render the root page."
  [state system]
  (if-let [page (current-page state)]
    (page system)
    (layout system state (content system state))))
