(ns burningswell.web.facebook-button
  (:require [no.en.core :refer [format-url]]
            [om-tools.core :refer-macros [defcomponentk]]
            [om.core :as om :include-macros true]
            [sablono.core :as html :include-macros true]
            [rum.core :as rum]
            [rum.mdl :as mdl]))

(defn dialog-url
  "Return the Facebook dialog url."
  [owner]
  (let [config (:facebook (om/get-shared owner :config))]
    (format-url
     {:scheme :https
      :server-name "www.facebook.com"
      :uri "/v2.3/dialog/oauth"
      :query-params
      {:client_id (:client-id config)
       :redirect_uri (:redirect-uri config)
       :scope "email"}})))

;; (defcomponentk facebook-button
;;   "Render a Facebook Login button."
;;   [owner opts]
;;   (render [_]
;;     (html/html
;;      [:div.facebook-button
;;       [:a {:href (dialog-url owner)}
;;        (or (:text opts)
;;            "Sign in with Facebook")]])))

(rum/defc facebook-button < rum/static
  "Render a Facebook Login button."
  [system text]
  (mdl/button
   {:class "facebook-button"
    :mdl [:colored :raised :ripple]
    :on-click (fn [e] (.preventDefault e))}
   text))
