(ns burningswell.web.countries-test
  (:require [burningswell.web.test :refer :all]
            [burningswell.db.spots :as spots]
            [clojure.test :refer :all]))

(deftest test-countries
  (with-webdriver-system [{:keys [webdriver] :as system} env]
    (browse-to system "/countries")
    (is (= (current-layout-link-text webdriver) "Countries"))
    (is (= (current-layout-link-icon webdriver) "terrain"))))

(deftest test-countries-near-mundaka
  (with-webdriver-system [{:keys [webdriver] :as system} env]
    (let [spot (spots/mundaka (-> system :api :db))]
      (browse-to system "/countries")
      (set-location-cookie! webdriver (:location spot))
      (browse-to system "/countries")
      (is (= (take 4 (country-headline-names webdriver))
             ["Spain" "Portugal" "United States" "Indonesia"])))))

(deftest test-countries-near-uluwatu
  (with-webdriver-system [{:keys [webdriver] :as system} env]
    (let [spot (spots/uluwatu (-> system :api :db))]
      (browse-to system "/countries")
      (set-location-cookie! webdriver (:location spot))
      (browse-to system "/countries")
      (is (= (take 4 (country-headline-names webdriver))
             ["Indonesia" "United States" "Spain" "Portugal"])))))
