(ns burningswell.web.components.paper-toast
  (:require [burningswell.web.mixins.event-handler :as events]
            [om.core :as om]
            [om-tools.core :refer-macros [defcomponentk]]
            [sablono.core :refer-macros [html]]))

(defn- show-toast
  "Show the toast."
  [owner]
  (.show (om/get-node owner)))

(defn- show-toast?
  "Return true if the toast should be shown, otherwise false."
  [prev next]
  (and (:visible prev)
       (not= (:visible-at prev)
             (:visible-at next))))

(defn- set-attributes
  "Set the Polymer attributes."
  [data owner]
  (doseq [[k v] (select-keys data [:duration :text :visible])]
    (.setAttribute (om/get-node owner) (name k) v)))

(defcomponentk paper-toast
  [data owner]
  (:mixins events/handler)
  (did-mount [_]
    (set-attributes data owner))
  (did-update [_ _ _]
    (set-attributes data owner))
  (will-receive-props [this next-props]
    (when (show-toast? data next-props)
      (show-toast owner)))
  (render [_]
    (html [:paper-toast])))
